/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;

public class FlowLayout
extends Layout {
    private int orientation = 1;

    public FlowLayout() {
    }

    public FlowLayout(int orientation) {
        this.orientation = orientation;
    }

    public void layoutContainer(Container parent) {
        int width = parent.getLayoutWidth() - parent.getSideGap() - parent.getStyle().getPadding(3);
        int x = parent.getStyle().getPadding(1);
        int y = parent.getStyle().getPadding(0);
        int rowH = 0;
        int start = 0;
        int maxComponentWidth = width - parent.getStyle().getPadding(1);
        int maxComponentHeight = parent.getLayoutHeight() - y - parent.getStyle().getPadding(2);
        int numOfcomponents = parent.getComponentCount();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            int marginY = cmp.getStyle().getMargin(0) + cmp.getStyle().getMargin(2);
            int marginX = cmp.getStyle().getMargin(1) + cmp.getStyle().getMargin(3);
            cmp.setWidth(Math.min(maxComponentWidth - marginX, cmp.getPreferredW()));
            cmp.setHeight(Math.min(cmp.getPreferredH(), maxComponentHeight - marginY));
            if (x == parent.getStyle().getPadding(1) || x + cmp.getPreferredW() < width) {
                cmp.setX(x + cmp.getStyle().getMargin(1));
                cmp.setY(y + cmp.getStyle().getMargin(0));
                x += cmp.getPreferredW() + cmp.getStyle().getMargin(3);
                rowH = Math.max(rowH, cmp.getPreferredH() + cmp.getStyle().getMargin(0) + cmp.getStyle().getMargin(2));
                continue;
            }
            this.moveComponents(parent, parent.getStyle().getPadding(1), y, width - x, rowH, start, i);
            x = parent.getStyle().getPadding(1);
            cmp.setX(x + cmp.getStyle().getMargin(1));
            cmp.setY((y += rowH) + cmp.getStyle().getMargin(0));
            rowH = cmp.getPreferredH() + cmp.getStyle().getMargin(0) + cmp.getStyle().getMargin(2);
            x += cmp.getPreferredW() + cmp.getStyle().getMargin(3);
            start = i;
        }
        this.moveComponents(parent, parent.getStyle().getPadding(1), y, width - x, rowH, start, numOfcomponents);
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd) {
        switch (this.orientation) {
            case 4: {
                x += width / 2;
                break;
            }
            case 3: {
                x += width;
            }
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponentAt(i);
            m.setX(m.getX() + x + m.getStyle().getMargin(1));
            m.setY(y + m.getStyle().getMargin(0) + (height - m.getPreferredH()) / 2);
        }
    }

    public Dimension getPreferredSize(Container parent) {
        int width = 0;
        int height = 0;
        int numOfcomponents = parent.getComponentCount();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            height = Math.max(height, cmp.getPreferredH() + cmp.getStyle().getMargin(0) + cmp.getStyle().getMargin(2));
            width += cmp.getPreferredW() + cmp.getStyle().getMargin(3) + cmp.getStyle().getMargin(1);
        }
        return new Dimension(width + parent.getStyle().getPadding(1) + parent.getStyle().getPadding(3), height + parent.getStyle().getPadding(0) + parent.getStyle().getPadding(2));
    }
}

